/**
 * Basis-Tests für SCORM 1.2
 * 
 * Testet die grundlegenden SCORM-API-Funktionen
 * 
 * @version 1.0
 * @author SCORM Test System
 */

function registerBasicTests(framework) {
    
    /**
     * Test 1: API-Verfügbarkeit
     */
    framework.test('API sollte verfügbar sein', 'basic', async (api) => {
        if (!api.isAvailable()) {
            throw new Error('SCORM API ist nicht verfügbar');
        }
    });
    
    /**
     * Test 2: Initialize
     */
    framework.test('Initialize sollte erfolgreich sein', 'basic', async (api) => {
        const result = api.initialize();
        if (!result.success) {
            throw new Error(`Initialize fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 3: GetValue nach Initialize
     */
    framework.test('GetValue student_id nach Initialize', 'basic', async (api) => {
        const result = api.getValue('cmi.core.student_id');
        if (!result.success) {
            throw new Error(`GetValue fehlgeschlagen: ${result.error}`);
        }
        if (!result.value || result.value === '') {
            throw new Error('student_id ist leer');
        }
    });
    
    /**
     * Test 4: GetValue student_name
     */
    framework.test('GetValue student_name', 'basic', async (api) => {
        const result = api.getValue('cmi.core.student_name');
        if (!result.success) {
            throw new Error(`GetValue fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 5: SetValue lesson_status
     */
    framework.test('SetValue lesson_status zu incomplete', 'basic', async (api) => {
        const result = api.setValue('cmi.core.lesson_status', 'incomplete');
        if (!result.success) {
            throw new Error(`SetValue fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 6: GetValue lesson_status nach SetValue
     */
    framework.test('GetValue lesson_status nach SetValue', 'basic', async (api) => {
        const result = api.getValue('cmi.core.lesson_status');
        if (!result.success) {
            throw new Error(`GetValue fehlgeschlagen: ${result.error}`);
        }
        if (result.value !== 'incomplete') {
            throw new Error(`Erwarteter Wert: 'incomplete', erhalten: '${result.value}'`);
        }
    });
    
    /**
     * Test 7: SetValue lesson_location
     */
    framework.test('SetValue lesson_location', 'basic', async (api) => {
        const result = api.setValue('cmi.core.lesson_location', 'page_1');
        if (!result.success) {
            throw new Error(`SetValue fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 8: Commit
     */
    framework.test('Commit sollte erfolgreich sein', 'basic', async (api) => {
        const result = api.commit();
        if (!result.success) {
            throw new Error(`Commit fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 9: GetValue nach Commit
     */
    framework.test('GetValue lesson_status nach Commit', 'basic', async (api) => {
        const result = api.getValue('cmi.core.lesson_status');
        if (!result.success) {
            throw new Error(`GetValue fehlgeschlagen: ${result.error}`);
        }
        // Prüfen ob Wert persistiert wurde
        if (result.value !== 'incomplete') {
            throw new Error(`Wert wurde nicht persistiert. Erwartet: 'incomplete', erhalten: '${result.value}'`);
        }
    });
    
    /**
     * Test 10: SetValue score.raw
     */
    framework.test('SetValue score.raw', 'basic', async (api) => {
        const result = api.setValue('cmi.core.score.raw', '85');
        if (!result.success) {
            throw new Error(`SetValue fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 11: SetValue total_time
     */
    framework.test('SetValue total_time', 'basic', async (api) => {
        const result = api.setValue('cmi.core.total_time', '00:05:30');
        if (!result.success) {
            throw new Error(`SetValue fehlgeschlagen: ${result.error}`);
        }
    });
    
    /**
     * Test 12: Finish
     */
    framework.test('Finish sollte erfolgreich sein', 'basic', async (api) => {
        const result = api.finish();
        if (!result.success) {
            throw new Error(`Finish fehlgeschlagen: ${result.error}`);
        }
    });
}

// Global verfügbar machen
window.registerBasicTests = registerBasicTests;

